function crossvalidate_ca_ccrf_lambdas_bfgs(dim, lambdas_a, lambdas_b, fold, useCACCRF, useGPU)
%--------------------------------------------------
% Description: CCRF - search for best beta lambdas
%              through cross validation
%--------------------------------------------------
% first we add the CCRF functionality here
addpath('../lib/');
addpath('../3dParty/mtimesx');

% also add data preparation helper functions
addpath('../data preparation/');
svrPredFolder = '../data/svrPreds/'; 

t_run = tic;
dimLabels = {'valence','arousal','power','expectancy'};
useIndicators = 0;

if(useCACCRF)
    outpath = 'CA_CCRF_BFGS/';
else
    outpath = 'CCRF_BFGS/';
end
if(~exist(outpath, 'dir'))
    mkdir(outpath);
end

resultsFile = [outpath 'cvLambdas_' dimLabels{dim} '_' num2str(fold) '.mat'];

fprintf('\n-----------------------------\n');
fprintf('Processing %s [Fold %d] \n',dimLabels{dim}, fold);
fprintf('-----------------------------\n');

%load cross validation indices
load(['../data/cvIndices/cvIndicesTrain2_' dimLabels{dim} '.mat'], 'indices');
numFilesInPartition = size(indices,1);
[testIndices, ~] = find(indices == fold); 
trainIndices = 1:numFilesInPartition;
trainIndices(testIndices) = [];  

if(useCACCRF)
    [xNormed, xOffsets, yNormed, yUnnormed] = prepareMultiData(dim, dimLabels, svrPredFolder, {'/train2_'});
else
    [xNormed, xOffsets, yNormed, yUnnormed] = prepareSingleData([svrPredFolder '/train2_' dimLabels{dim} '.mat']);
end

xNormedTrain = xNormed(trainIndices,:);
xNormedTest = xNormed(testIndices,:);

yNormedTrain = yNormed(trainIndices,:);
yUnnormedTrain = yUnnormed(trainIndices,:);

yNormedTest = yNormed(testIndices,:);
yUnnormedTest = yUnnormed(testIndices,:);

xOffsetsTrain = xOffsets(trainIndices);
xOffsetsTest = xOffsets(testIndices);

nExamples = numel(yNormedTrain);

foldResultsCorr = zeros(numel(lambdas_a), numel(lambdas_b));
foldResultsRmse = zeros(numel(lambdas_a), numel(lambdas_b));
lambdaAValsCorr = zeros(numel(lambdas_a), numel(lambdas_b));
lambdaBValsCorr = zeros(numel(lambdas_a), numel(lambdas_b));

nFeatures = size(xNormedTrain{1},2);

nGaussians = 5;
nNeighbor = 5;

% this will create a family of exponential decays with different sigmas
similarities = {};
range = 1:nFeatures;
for n=1:nGaussians
    sigma = 2.0^(-n-5);
    exponentialDecay = @(x, m) similarityGauss(x, sigma, range, m);
    similarities = [similarities; {exponentialDecay}];
end

for n=1:nNeighbor
    neigh = n;
    neighFn = @(x, m) similarityNeighbor(x, neigh, range, m);
    similarities = [similarities; {neighFn}];
end
        
% initialise the parameter estimates
alphas = zeros(nFeatures, 1);
betas = zeros(numel(similarities), 1);    

masksTrain = cell(numel(yNormedTrain),1);
masksTest = cell(numel(yUnnormedTest),1);
  
[ ~, PrecalcQ2s, PrecalcQ2sFlat, PrecalcYqDs ] = CalculateSimilarities( size(xNormedTrain,1), xNormedTrain, yNormedTrain, masksTrain, similarities );

[ ~, ~, PrecalcQ2sFlatTest, ~ ] = CalculateSimilarities(  size(xNormedTest,1), xNormedTest, yNormedTest, masksTest, similarities );

for i=1:numel(lambdas_b)
    
    lambda_b = lambdas_b(i);
        
    for j=1:numel(lambdas_a)

        tic 
        
        lambda_a = lambdas_a(j);
        
        fprintf('\nx-val => [lambdaAlpha: %.4g lambdaBeta: %.4g]\n', lambda_a, lambda_b);        
        thresholdX = 1e-8;
        thresholdFun = 1e-4;
        
        if(useGPU)
            [alphasCCRF, betasCCRF, scaling] = CCRF_training_bfgs_gpu(nExamples, thresholdX, thresholdFun, xNormedTrain, yNormedTrain, yUnnormedTrain, masksTrain, alphas, betas, lambda_a, lambda_b, similarities, useIndicators, PrecalcQ2s, PrecalcQ2sFlat, PrecalcYqDs);
        else
            [alphasCCRF, betasCCRF, scaling] = CCRF_training_bfgs(nExamples, thresholdX, thresholdFun, xNormedTrain, yNormedTrain, yUnnormedTrain, masksTrain, alphas, betas, lambda_a, lambda_b, similarities, useIndicators, PrecalcQ2s, PrecalcQ2sFlat, PrecalcYqDs);
        end
        
        fprintf('betas: min: %.4f, med: %.4f, max: %.4f\n', min(betasCCRF), median(betasCCRF), max(betasCCRF));
        fprintf('alphas: '); fprintf('%.4f\t', alphasCCRF');
        alpha_prop = (alphasCCRF'*ones(nFeatures,1)) \ alphasCCRF;   
        fprintf('\nalpha proportions: ');fprintf('%.4f\t', alpha_prop'); fprintf('\n');

        %--- cross-validation evaluation                
        [~, ~, meanCorr, meanRMS] = evaluateCCRFmodel(alphasCCRF, betasCCRF, xNormedTest, xOffsetsTest, yUnnormedTest, masksTest, useIndicators, similarities, scaling, false, PrecalcQ2sFlatTest);
        fprintf('CCRF corr: %.3f, rmse: %.3f\n', meanCorr, meanRMS);
        foldResultsCorr(i,j) = meanCorr;
        foldResultsRmse(i,j) = meanRMS;
        lambdaAValsCorr(i,j) = lambda_a;
        lambdaBValsCorr(i,j) = lambda_b;

        toc;

    end
end

save(resultsFile, 'foldResultsCorr', 'foldResultsRmse', 'lambdas_a', 'lambdas_b', 'lambdaAValsCorr', 'lambdaBValsCorr');
toc(t_run);